#!/usr/bin/perl

use strict;
use POSIX;
use FindBin qw($Bin);

my $cfgfilename =  "svcconfig.ini";
my $SVCNAME = 'SAWS';

my ($topdir_path);

{#compute $topdir_path
	chdir $FindBin::Bin;
	my $dirwas = getcwd();
	chdir('..\..\..\..\..\..');
	$topdir_path = getcwd();
	$topdir_path .= '\\' if substr($topdir_path,-1) ne '\\';
	chdir $dirwas;
}

{
	if (index($topdir_path,' ') != -1) 
	{
		my $p = $topdir_path;
		$p =~ s, ,!!!SPACE-HERE!!!,g;
		system("${topdir_path}site/stunnixwebsrv/showmessage",
			"The full path to the CD contains space character: $p. Please move it to some other directory so the full path to it has no spaces, e.g. c:\\work");
		exit(1);
	}
}

{#generate config file for it
	open(FO,">${cfgfilename}") || die("can't create svcconfig.ini: $!");
	print FO <<"EOT";
[${SVCNAME}]
startup=${topdir_path}runcd-as-service.exe /service /nologo /nobrowser
shutdown_method=command
shutdown=${topdir_path}runcd-as-service.exe /stop
EOT
	close FO;
}

{#generate scripts
	my $d = $FindBin::Bin . "\\";
	$d =~ s,/,\\,g;
	open(FO,">../add service (run it as Admin).bat");
	print FO  <<EOT;
\@echo off
"${d}srvstart.exe"  install $SVCNAME -c "${d}${cfgfilename}"
"${d}..\\..\\..\\..\\showmessage.exe" Added service named $SVCNAME. IMPORTANT! Configure it to run as some real user! Accounts for running services have very limited permissions, so SAWS won't start if you do not configure service to run as some real user!
rem uncomment next line to keep console open on screen to read trace output
rem timeout /T 60 /NOBREAK > NUL
EOT
	close FO;


	open(FO,">../remove service (run it as Admin).bat");
	print FO  <<EOT;
\@echo off
"${d}srvstart.exe"  remove $SVCNAME 
rem uncomment next line to keep console open on screen to read trace output
rem timeout /T 60 /NOBREAK > NUL
EOT
	close FO;
}

