#!/usr/bin/perl

use strict;
use POSIX;

my ($is_service) = 0; #1 if service, 0 if agent
{
    my @args = @ARGV;
    $is_service = 1 if ($args[0] eq 'service');
}

my $cwd = getcwd();

my $svcname = 'com.stunnix.webserver';
my $user = $ENV{USER};


my $lines=<<"EOT";
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple Computer//DTD PLIST 1.0//EN"
        "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
 <dict>
    <key>Label</key>
	<string>$svcname</string>
    <key>ProgramArguments</key>
        <array>
    	    <string>$cwd/backend</string>
    	    <string>start_service</string>
        </array>
    <key>RunAtLoad</key>
        <true/>
    <key>OnDemand</key>
        <false/>
    <key>UserName</key>
        <string>$user</string>
 </dict>
</plist>
EOT

my $fname =  ( $is_service ? '/Library/LaunchDaemons/' : "/Library/LaunchAgents/" ) . $svcname . '.plist';
open(F,">$fname") || die("can't open $fname for writing");
print F $lines;
close F;

print  "\n\n\n\nSUCCESSFULLY installed Stunnix Web Server as " . ($is_service ? 'daemon' : 'agent') . 
    " by placing service description file at ${fname}";
