
=head1

Expects that $ARGV[0] is name of real perl script to execute, relative to the
$^X

The job of this script is mainly setting up %INC and $ENV{PERLLIB}

=cut



{
    my $interpdir = $^X;
    $interpdir =~ s,/[^/]+$,,g;
    $interpdir =~ s,\\[^\\]+$,,g;
    $interpdir .= '/lib/';
    $ENV{PERLLIB} = $ENV{PERLLIB} ? "$ENV{PERLLIB}:$interpdir" : $interpdir;
    $ENV{PERL5LIB} = $ENV{PERL5LIB} ? "$ENV{PERL5LIB}:$interpdir" : $interpdir;

    unshift @INC, $interpdir; 
    #print "INC is " . join("\n",@INC);
}

if (!@ARGV)
{
    print "usage: $0 <name-of-script-to-exec> [script-arguments]\n";
    exit 1;
}
{
    my $script = shift @ARGV;
    if (!-f $script) {
	print "error: can not open $script for reading: $!\n";
	exit 2;
    }
    #print "PERLLIB=$ENV{PERLLIB}\n";
    #print "PERL5LIB=$ENV{PERL5LIB}\n";
    if ($^O ne 'linux') {
	do "$script";print "there were problems executing $script: $@\n" if $@;    
    } else {
	#for some reasons @INC on Linux can't be manipulated even push @INC, '/dir' is wrapped in BEGIN, so we rely on PERLLIB being defined in this script, 
	#so that child will respect it.
	exec($^X,$script,@ARGV);
    }    
}


