#This file is interpreted after ../stunnixwebsrv/siteinfo.pm. To allow 
#effortless upgrades, it's greatly recommended to put all your code to this
#file rather than to ../stunnixwebsrv/siteinfo.pm.
#
#This file is just perl source file.
#The purpose of this file is to alter entries in the hash named %config 
#declared and used by the file ../stunnixwebsrv/startsite.pl. Read 
#../stunnixwebsrv/startsite.pl for more insight on what entries are present 
#in this hash and how they are used.
#
#See docs on all settings here:
#	http://www.stunnix.com/support/doc/aws/startsite.shtml
#
#The only setting that is HIGHLY recommended to alter is 'sitename' - to allow
#several instances of SPWS serving different applications to work on the same 
#machine for the same user.

<% 
    my $s; my %o = %{$cdcfg::prj->{opts}}; 
    $o{webserver_inspector} +=0 ;
%>


my (\%config_w,\%config_l,\%config_m);
my (\$os,\$config_our) = \$^O =~ /Win/ ? ('w',\\\%config_w) 
    : \$^O =~ /darwin/ ? ('m',\\\%config_m) : ('l',\\\%config_l);



\$config{sitename} = "<% 
    $s = $o{site_uniq_identifer};
    $s =~ s/[^-a-zA-Z0-9_]/_/g;
    print $s;
%>";

\$config{_debugtofile} = "$o{siteinfo__debug}";
\$config{webserver_inspector} = "$o{webserver_inspector}";

\$config{urlpath} = "$o{initial_url}";
\$config_w{urlpath} = "$o{initial_url_w}" if length("$o{initial_url_w}");
\$config_m{urlpath} = "$o{initial_url_m}" if length("$o{initial_url_m}");
\$config_l{urlpath} = "$o{initial_url_l}" if length("$o{initial_url_l}");

\$config{mysqld_options_1}   = "$o{mysqld_options_any}";
\$config_w{mysqld_options_2} = "$o{mysqld_options_w}";
\$config_m{mysqld_options_2} = "$o{mysqld_options_m}";
\$config_l{mysqld_options_2} = "$o{mysqld_options_l}";

\$config_m{osx_nodewebkit_bundle_name} = "$o{m_nodewebkit_bundle_name}";

<%
    my $plat;
    foreach $plat (@{$cdcfg::cfg->{product}->{oses_list}})
    {
	print "\n";
	foreach my $stem (qw(before_server before_browser after_browser))
	{
	    print "\n";
	    foreach my $i (1..3)
	    {
		print "\$config_${plat}" . "{program_to_run_${stem}_${i}} = " .
			"'". $o{"exta_prog_run_${stem}_${plat}_${i}"} . "';\n" .
                      "\$config_${plat}" . "{program_to_run_${stem}_${i}_sleep_seconds} = " .
			"'". $o{"exta_prog_run_${stem}_${plat}_${i}_delay"} . "';\n" ;
	    }
	};
    };

    foreach $plat (@{$cdcfg::cfg->{product}->{oses_list}})
    {
	print "\n" . "\$config_${plat}" . "{nodewebkit_stop_server_on_close} = " .
	    ($o{$plat . "_nodewebkit_stop_on_browser_close"}+0) . ";\n";
    }
%>



<% 
    if ($o{browser_w} eq 'default') {
	$s = '$config_w{win32_prefer_ie} = 0;';
    } elsif ($o{browser_w} eq 'none') { 
	$s = '$config_w{nobrowser} = 1;';
    } elsif ($o{browser_w} eq 'msie_kiosk') {
	$s = '$config_w{win32_prefer_ie_kiosk_mode} = 1;';
    } elsif ($o{browser_w} eq 'portableff') {
	$s = '$config_w{win32_prefer_ff_embedded} = 1;';
    } elsif ($o{browser_w} eq 'nodewebkit') {
	$s = '$config_w{win32_nodewebkit} = 1; $config_w{win32_prefer_ie} = 0;';
    } else {
	$s = '$config_w{win32_prefer_ie} = 1;';
        foreach my $p (qw(addressbar fullscreen height left
                    menubar resizable silent statusbar theatermode
                    toolbar top width))
	{
	    $s .= "\n" . "\$config_w{win32_msie_prop__${p}} = '" .
		    $o{"msie_${p}"} . "';";
	};	
    }
    print "$s\n\n";

#OSX browser
    if ($o{browser_m} eq 'default') {
	$s = '$config_m{macosx_prefer_ie} = 0;';
    } elsif ($o{browser_m} eq 'none') { 
	$s = '$config_m{nobrowser} = 1;';
    } elsif ($o{browser_m} eq 'msie') {
	$s = '$config_m{macosx_prefer_ie} = 1;';	
    } elsif ($o{browser_m} eq 'nodewebkit') {
	$s = '$config_m{osx_nodewebkit} = 1;';	
    }

    print "$s\n\n";

    print '$config_m{osx_prefer_ff_embedded} = 1;'
	if ($o{browser_m} eq 'portableff');

#linux browser
    if ($o{browser_l} eq 'none') { 
	$s = '$config_l{nobrowser} = 1;';
    } elsif ($o{browser_l} eq 'nodewebkit') { 
	$s = '$config_l{lnx_nodewebkit} = 1;';
    } else {
	$s = '';
    };
    print "$s\n\n";
%>


\$config{port_to_start_scanning_from} = <% print ((0+$o{srv_listen_port}) ? 
	(0+$o{srv_listen_port}) : 9000);  %>;
\$config{show_win32_firewall_alert} = $o{srv_firewall};
\$config{win32_firewall_alert_message} = "<%
    #"
    $s = $o{srv_firewall_message};
    if ($s)
    {
	$s =~ s/(.)/sprintf '\\x%02x', ord($1)/eg;
	print $s;
    };
%>";

\$config{do_not_eject_on_shutdown} = $o{srv_dont_eject_cd_on_shutdown};

foreach (keys \%\$config_our) { \$config{\$_} = \$config_our->{\$_}; };

<%
    foreach my $plat ('ANY',@{$cdcfg::cfg->{product}->{oses_list}})
    {
	print "\n";
	print "if (\$os eq '$plat') {\n" if ($plat ne 'ANY');
	print $o{"siteinfo_${plat}_lines"} . "\n\n";
	foreach my $i (1..6)
	{
	    my ($n_nm,$v_nm) = ("envvar_${plat}_${i}_name","envvar_${plat}_${i}_value");	    
	    print "\$ENV{$o{$n_nm}} = \"$o{$v_nm}\";\n" if length($o{$n_nm});
	};
	print "}\n" if ($plat ne 'ANY');
    };
%>

\$config{win32_show_trayicon} = <% print (0+$o{win32_show_trayicon}); %>;

\$config{osx_show_trayicon} = <% print (0+$o{osx_show_trayicon}); %>;


<%  if ($o{aspnet_change_startpage}) { %>
\$config{win32_dotnet_absent_action} = 'change_startpage';
\$config{win32_dotnet_absent_startpage} = "$o{aspnet_absent_use_startpage}";
<% } %>

\$config{win32_use_httpd2} = "$o{win32_httpd2}";
\$config{win32_try_using_pipes} = "$o{win32_try_namedpipes}";
<% if ($o{httpd2}) { %>
\$config{httpd2} = "$o{httpd2}";
<% } %>

\$config{win32_ff_stop_on_close} = <% print (0+$o{win32_stop_on_browser_close}); %>;
\$config{osx_ff_stop_on_close} = <% print (0+$o{osx_stop_on_browser_close}); %>;

\$config{require_diskspace_mb_windows} = <% print (0+$o{min_freespace_w}); %>;
\$config{require_diskspace_mb_linux} = <% print (0+$o{min_freespace_l}); %>;
\$config{require_diskspace_mb_macosx} = <% print (0+$o{min_freespace_m}); %>;




<%
    #" balance quotes to fix syntax highlighting
    {
	my $preheat_urls_str = $o{"srv_preheat_urls"};
	my @parts;
	foreach (split(/\r?\n/,$preheat_urls_str))
	{
	    s,#.*,,; #remove comments
	    s,\r?\n,,; #remove CRs
	    if (/^\s*(\S*)\s*$/) {
		push @parts, $1 if length($1);
	    }
	}
	{	
	    my $s = $o{"wordpress_fix_urls"};
	    unshift @parts, $s if length($s);
	}
	print '$config{preheat_urls}="' . join('|',@parts) . '";';
    }
%>
